﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;
using VIRP.EFR.BLL;
using VIRP.EFR.BO;
using VIRP_WEB.Custom.EFR;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class FragLabResult : UserControl
    {
        private string CurrentUser
        {
            get
            {
                return HttpContext.Current.User.Identity.Name;
            }
        }
        private int CurrentRegistryId { get; set; }

        protected void Page_Init(object sender, EventArgs e)
        {
            LoadCurrentCredentialsFromParentForm();

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRFragments.ClientID + "');", true);
        }

        private void LoadCurrentCredentialsFromParentForm()
        {
            Control baseControl = Parent;
            EfrBasePage basePage = baseControl.Page as EfrBasePage;
            if (basePage != null)
                CurrentRegistryId = basePage.CurrentRegistryId;
        }

        public void BindData(WKF_CASE_ACTIVITY activity, WKF_CASE_ACTIVITY order, bool fullRefresh)
        {
            // boolean fullRefresh is added since deserialize is not persisting the analysismethod and fragment type values

            if (order != null)
            {
                if (fullRefresh == true)
                {
                    var wCase = VIRP.CRS.BLL.WKF_CASEManager.GetItem(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ID);

                    var interpretation = WKF_CASE_ACTIVITYManager.GetitemsByWorkflowCaseId(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ID)
                        .Where(a => a.STD_WKFACTIVITYTYPE_ID == Convert.ToInt16(WorkFlowActivityTypes.Interpretation))
                        .FirstOrDefault();

                    PatientDetails patientDetails = PatientDetailsManager.GetItem(CurrentUser, CurrentRegistryId, wCase.PATIENT_ID);

                    if (interpretation != null &&
                            (interpretation.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.New ||
                                interpretation.STD_WKFACTIVITYSTS_ID == (int)WorkflowCaseActivityStatus.InProcess))
                    {
                        patientWorkflowsLink.Text = patientDetails.FULL_NAME;
                        patientWorkflowsLink.NavigateUrl = String.Format("~/Custom/EFR/Patients/PatientWorkflows.aspx?patientId={0}", patientDetails.PATIENT_ID);
                        lblFullName.Visible = false;
                        patientWorkflowsLink.Visible = true;
                        LabelforFullNameLabel.AssociatedControlID = patientWorkflowsLink.ID;
                    }
                    else
                    {
                        lblFullName.Text = patientDetails.FULL_NAME;
                        lblFullName.Visible = true;
                        patientWorkflowsLink.Visible = false;
                        LabelforFullNameLabel.AssociatedControlID = lblFullName.ID;
                    }

                    lblICN.Text = patientDetails.PATIENT_ICN;
                    lblSnum.Text = patientDetails.Snum;
                    if (patientDetails.BIRTH_DATE.HasValue)
                        lblBirthday.Text = patientDetails.BIRTH_DATE.GetValueOrDefault().ToShortDateString();
                    if (!string.IsNullOrEmpty(patientDetails.GENDER))
                        lblGender.Text = patientDetails.GENDER;

                    var orders = LAB_ORDERManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, order.WKF_CASE_ACTIVITY_ID);

                    if (orders.Any())
                    {
                        var firstOrder = orders.First();

                        if (firstOrder.LAB_REPORT_DATE.HasValue)
                            txtLabRptDate.Text = orders.First().LAB_REPORT_DATE.GetValueOrDefault().ToShortDateString();

                        txtAccession.Text = firstOrder.BSO_NUMBER;
                        txtLabID.Text = firstOrder.LAB_ID_NUMBER;
                        txtLabCd.Text = firstOrder.METALS_LAB_CODE;
                    }
                }

                // Populate Analyte details
                var fragments = FRAGMENT_ANALYSISManager.GetItemsByActivity(CurrentUser, CurrentRegistryId, activity.WKF_CASE_ACTIVITY_ID);
                GridViewEFRFragments.DataSource = fragments != null ? fragments : new List<FRAGMENT_ANALYSIS>();
                GridViewEFRFragments.DataBind();
            }
        }

        public void Fragments_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRFragments.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRFragments.SelectedValue);
                Response.Redirect(string.Format("~/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretationFragment.aspx?fragmentId={0}", id), false);
                //Response.Redirect($"~/Custom/EFR/InterpretationAndFollowUp/FragLabInterpretationFragment.aspx?fragmentId={id}", false);
            }
        }
    }
}
